<?php
use yii\helpers\Url;
use yii\helpers\Html;

return [
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'name',
    ],
    [
        'attribute' => 'groups',
        'contentOptions' => ['class' => 'text-left', 'style' => 'min-width:70px;'],
        'value' => function ($model) {
            $_ = $model->groups;
            if($_ == null){
                $a = [];
            }else{
                $a = json_decode($model->groups);
            }
            
            $b = '';
            $c = ', ';
            for($i = 0; $i < count($a); $i++) {
                if($i == count($a)-1){
                    $c = '';
                }
                $b .= $a[$i] . $c;
            }
            return $b;
        }
        
    ],
    [
        'class' => 'kartik\grid\ActionColumn',
        'dropdown' => false,
        'vAlign'=>'middle',
        'template' => '{packettools} {update} {delete}',
        'urlCreator' => function($action, $model, $key, $index) { 
                return Url::to([$action,'id'=>$key]);
        },
        'buttons' => [
            'packettools' => function ($url, $model) {
                return Html::a(
                    '<span class="glyphicon glyphicon-wrench" aria-hidden="true"></span>',
                    $url, 
                    [
                        'title' => 'Packet tools',
                        'data-pjax' => '0',
                        'aria-label' => 'packettools',
                        //'role'=>'modal-remote',
                    ]
                );
                
            },
        ],
        'updateOptions'=>['role'=>'modal-remote','title'=>'Update'],
        'deleteOptions'=>['role'=>'modal-remote','title'=>'Delete', 
                          'data-confirm'=>false, 'data-method'=>false,// for overide yii data api
                          'data-request-method'=>'post',
                          'data-toggle'=>'tooltip',
                          'data-confirm-title'=>'Are you sure?',
                          'data-confirm-message'=>'Are you sure want to delete this item'], 
    ],

];   